using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    public struct Point
    {
        public double X;
        public double Y;

        public Point(double x, double y)
        {
            X = x;
            Y = y;
        }
    }

    static void Main(string[] args)
    {
        int N = int.Parse(Console.ReadLine());
        
        List<Point> points = new List<Point>();
        
        for (int i = 0; i < N; i++)
        {
            var coords = Console.ReadLine().Split(' ');
            points.Add(new Point(double.Parse(coords[0]), double.Parse(coords[1])));
        }
        
        double minArea = double.MaxValue;
        Point[] minPolygon = null;

        for (int i = 0; i < N; i++)
        {
            var subset = points.Where((p, index) => index != i).ToList();
            var hull = ConvexHull(subset);
            double area = PolygonArea(hull);
            
            if (area < minArea)
            {
                minArea = area;
                minPolygon = hull.ToArray();
            }
        }
        
        
        foreach (var point in minPolygon)
        {
        }


        Console.WriteLine(minArea);
    }

    public static List<Point> ConvexHull(List<Point> points)
    {
        points = points.OrderBy(p => p.X).ThenBy(p => p.Y).ToList();
        int n = points.Count;

        if (n <= 1) return points;

        List<Point> hull = new List<Point>();

        foreach (var point in points)
        {
            while (hull.Count >= 2 && Cross(hull[hull.Count - 2], hull[hull.Count - 1], point) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(point);
        }

        int lowerCount = hull.Count;
        for (int i = n - 2; i >= 0; i--)
        {
            var point = points[i];
            while (hull.Count > lowerCount && Cross(hull[hull.Count - 2], hull[hull.Count - 1], point) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(point);
        }

        hull.RemoveAt(hull.Count - 1);

        return hull;
    }

    public static double Cross(Point o, Point a, Point b)
    {
        return (a.X - o.X) * (b.Y - o.Y) - (a.Y - o.Y) * (b.X - o.X);
    }

    public static double PolygonArea(List<Point> points)
    {
        double area = 0;
        int j = points.Count - 1;
        
        for (int i = 0; i < points.Count; i++)
        {
            area += (points[j].X + points[i].X) * (points[j].Y - points[i].Y);
            j = i;
        }
        return Math.Abs(area / 2.0);
    }
}